
struct Unparsed : Identifier
{
    wxString error;
    int errorpos;
    int cursor, cursorend;

    Unparsed() : errorpos(-1), cursor(0), cursorend(0) {}

    void Render(wxDC &dc, int x, int y, int xs, int ys)
    {
        dc.SetPen(*wxRED_PEN);
        dc.SetBrush(*wxTRANSPARENT_BRUSH);
        dc.DrawRectangle(x, y, xs, ys);
        dc.DrawRectangle(x+1, y+1, xs-2, ys-2);
        sys->PickFont(dc, 0, STYLE_FIXED);
        if(errorpos>=0)
        {
            int errx1, errx2, _;
            dc.GetTextExtent(name.Left(errorpos-1), &errx1, &_);
            dc.GetTextExtent(name.Left(errorpos),   &errx2, &_);
            dc.SetBrush(*wxRED_BRUSH);
            dc.DrawRectangle(x+errx1+2, y+2, errx2-errx1, ys);
        }
        dc.SetPen(*wxBLACK_PEN);
        dc.DrawText(name, x+2, y+2);
    }

    void DrawCursor(wxDC &dc, uint color, bool cursoronly, int cx, int cy)
    {
        sys->PickFont(dc, 0, STYLE_FIXED);

        int h = dc.GetCharHeight();
        wxString ls = name;
        if(cursor!=cursorend)
        {
            if(!cursoronly)
            {
                ls.Truncate(cursorend);
                int x1, x2;
                dc.GetTextExtent(ls, &x2, NULL);
                ls.Truncate(cursor);
                dc.GetTextExtent(ls, &x1, NULL);
                if(x1!=x2) DrawRectangle(dc, color, cx+x1+2, cy+1, x2-x1, h-1
                    #ifdef SIMPLERENDER
                    , true
                    #endif
                    );
            }
        }
        else
        {
            ls.Truncate(cursor);
            int x;
            dc.GetTextExtent(ls, &x, NULL);
            if(sys->blink)
                #ifdef SIMPLERENDER
                DrawRectangle(dc, color, cx+x+2, cy+2, 2, h-2);
                #else
                DrawLine(dc, 0xFFFFFF, cx+x+2, cy+2, 0, h);
                #endif
        }
    }

    #define ifrangeselremove if(cursor!=cursorend) { name.Remove(cursor, cursorend-cursor); cursorend = cursor; }

    void Insert(wxString i) { ifrangeselremove; name.insert(cursor, i); }
    void Delete()           { ifrangeselremove else if(cursor<(int)name.Len()) { name.Remove(cursor, 1); }; }
    void Backspace()        { ifrangeselremove else if(cursor>0)               { name.Remove(--cursor, 1); --cursorend; }; }
    void Key(int k)         { ifrangeselremove; name.insert(cursor++, 1, k); cursorend = cursor; }
};
