
#include "stdafx.h"

#ifndef __WXMSW__
    #define SIMPLERENDER
#endif

//#define SIMPLERENDER // for testing

void DrawRectangle(wxDC &dc, uint c, int x, int y, int xs, int ys, bool outline = false)
{
    if(outline) dc.SetBrush(*wxTRANSPARENT_BRUSH);
    else dc.SetBrush(wxBrush(wxColour(c)));
    dc.SetPen(wxPen(wxColour(c)));
    dc.DrawRectangle(x, y, xs, ys);
}

void DrawLine(wxDC &dc, uint c, int x, int y, int xd, int yd)
{
    dc.SetPen(wxPen(wxColour(c)));
    dc.DrawLine(x, y, x+xd, y+yd);
}

int g_grid_outer_spacing = 3;
int g_line_width = 1;
int g_selmargin = 2;
int g_deftextsize = 12;
int g_grid_left_offset = 15;

int g_scrollrate = 80; // FIXME: must be configurable

static uint celltextcolors[] =
{
    0xFFFFFF, 0x000000, 0x202020, 0x404040, 0x606060, 0x808080, 0xA0A0A0, 0xC0C0C0, 0xE0E0E0,
    0x000080, 0x0000FF, 0x8080FF,
    0x008000, 0x00FF00, 0x80FF80,
    0x800000, 0xFF0000, 0xFF8080,
    0x800080, 0xFF00FF, 0xFF80FF,
    0x008080, 0x00FFFF, 0x80FFFF,
    0x808000, 0xFFFF00, 0xFFFF80,
    0xFFFFFF,   // CUSTOM COLOR!
};
#define CUSTOMCOLORIDX 27


struct Restructor
{
    enum { TS_VERSION = 9, TS_TEXT = 0, TS_GRID, TS_BOTH, TS_NEITHER };

    enum { A_NEW = 500, A_OPEN, A_CLOSE, A_SAVE, A_SAVEAS, A_CUT, A_COPY, A_PASTE, A_NEWGRID, A_NEWCELL, A_REPGRID, A_UNDO, A_ABOUT,
           A_RUN, A_CLRVIEW, A_MARKDATA, A_MARKVIEWH, A_MARKVIEWV, A_MARKCODE, A_IMAGE, A_EXPIMAGE, A_EXPXML, A_EXPHTMLT, A_EXPHTMLO, A_EXPTEXT,
           A_EXPCOPY, A_ZOOMIN, A_ZOOMOUT, A_REMGRID, A_TRANSPOSE, A_MERGE, A_DELETE, A_BACKSPACE,
           A_LEFT, A_RIGHT, A_UP, A_DOWN,
           A_MLEFT, A_MRIGHT, A_MUP, A_MDOWN,
           A_SLEFT, A_SRIGHT, A_SUP, A_SDOWN,
           A_ALEFT, A_ARIGHT, A_AUP, A_ADOWN,
           A_SCLEFT, A_SCRIGHT, A_SCUP, A_SCDOWN,
           A_AW1, A_AW2, A_AW3, A_AW4, A_AW5, A_AW6, A_AW7,
           A_DEFFONT, A_IMPXML, A_IMPXMLA, A_IMPTXTI, A_IMPTXTC, A_IMPTXTS, A_IMPTXTT, A_HELP, A_MARKVARD, A_MARKVARU, A_SHOWSBAR, A_SHOWTBAR, A_TRADSCROLL, A_HOME, A_END,
           A_PRINT, A_PREVIEW, A_PAGESETUP, A_PRINTSCALE, A_EXIT, A_NEXT, A_PREV, A_BOLD, A_ITALIC, A_TT, A_UNDERL, A_SEARCH, A_REPLACE, A_REPLACEONCE, A_REPLACEALL, A_SELALL, A_CANCELEDIT, A_BROWSE, A_ENTERCELL,
           A_CELLCOLOR, A_TEXTCOLOR, A_INCSIZE, A_DECSIZE, A_INCWIDTH, A_DECWIDTH, A_ENTERGRID, A_LINK, A_SEARCHNEXT, A_CUSTCOL, A_COLCELL, A_SORT, A_SEARCHF, A_MAKEBAKS, A_TOTRAY, A_AUTOSAVE,

           A_REFACTOR, A_REFACTORAGGR

         };


    enum { STYLE_BOLD = 1, STYLE_ITALIC = 2, STYLE_FIXED = 4, STYLE_UNDERLINE = 8 };

    struct Node;
    struct Selection;
    #include "identifier.h"
    #include "shared.h"
    #include "placeholder.h"
    #include "userfunction.h"
    #include "builtinfunction.h"
    #include "unparsed.h"
    #include "node.h"
    #include "autorefactor.h"
    #include "parser.h"
    #include "sel.h"

    struct MyFrame;
    struct TSCanvas;

    #include "document.h"
    #include "system.h"

    #include "mywxtools.h"
    #include "mycanvas.h"
    #include "myframe.h"
    #include "myapp.h"

    static System *sys;
};

Restructor::System *Restructor::sys = NULL;

IMPLEMENT_APP(Restructor::MyApp)

#include "myevents.h"

