
struct Identifier
{
    wxString name;
    int xs, ys;

    virtual ~Identifier() {};

    int Layout(wxDC &dc)
    {
        sys->PickFont(dc, 0, STYLE_FIXED);
        dc.GetTextExtent(name, &xs, &ys);
        return xs;
    }

    int Render(wxDC &dc, int x, int y, int yspace)
    {
        sys->PickFont(dc, 0, STYLE_FIXED);
        dc.DrawText(name, x, y+(yspace-ys)/2);
        return xs;
    }

    static wxString GenName(bool funname, int gennames)
    {
        wxChar basechar = funname ? 'a' : 'A';
        if(gennames<26) return wxString()+wxChar(basechar+gennames);
        return wxString()+wxChar(basechar+gennames/26-1)+wxChar(basechar+gennames%26);
    }
};
